DROP PROCEDURE IF EXISTS sp_mostrarProveedores;

delimiter $
CREATE DEFINER=`targoxco`@`localhost` PROCEDURE `sp_mostrarProveedores`(IN `p_idProveedor` INT, IN `p_tipoOperacion` INT)
BEGIN    
	IF p_tipoOperacion = 1 THEN 
		select 
			P.idProveedor,
            P.nombreEmpresa,
			(SELECT CONCAT(C.nombre, ' ', C.apePaterno) FROM CONTACTO C WHERE C.idProveedor = p_idProveedor LIMIT 1) as nombre,
            M1.descripcion as rubro,
            M2.descripcion as estado,
			P.ruc,
			P.direccion,
			P.telefono1,
            P.telefono2,
            P.telefono3,
			P.email   ,
            (CASE WHEN P.activo = 1 THEN 'SI'
				WHEN P.activo = 0 THEN 'NO'
			END) AS activo
		FROM PROVEEDOR P
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idRubro 
        LEFT JOIN MULTITABLA M2 ON M2.valor = P.idEstado AND M2.dep_id = 2
        WHERE M1.dep_id = 1
		ORDER BY P.nombreEmpresa;
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN 	
		select 
			P.idProveedor, 
			P.idContacto,
            P.nombreEmpresa,
			CONCAT(C.nombre, ' ', C.apePaterno) as nombre,
            M1.descripcion as categoria,
            M2.descripcion as estado,
			P.ruc,
			P.direccion,
			P.telefono1,
            P.telefono2,
            P.telefono3,
			P.email,
            P.activo
		from PROVEEDOR P
		INNER JOIN CONTACTO C ON C.idContacto = P.idContacto
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idRubro 
        INNER JOIN MULTITABLA M2 ON M2.valor = P.idEstado 
        WHERE M1.dep_id = 1 AND M2.dep_id = 2 AND P.activo = 1 and C.activo = 1
		ORDER BY P.nombreEmpresa;
	END IF;
    
    IF p_tipoOperacion = 3 THEN 	
		SELECT
			P.idProveedor, P.idRubro, P.idEstado,
            P.idPais, P.idCiudad, P.nombreEmpresa, P.nombreComercial,
            P.ruc, P.email, P.telefono1, P.telefono2, P.telefono3, 
            P.direccion, P.referencia, P.cuentaInstagram, P.cuentaFacebook, P.activo as activoProveedor,
			C.idContacto, C.dni, C.nombre, C.apePaterno, C.apeMaterno,
            C.cargo, C.telefono, C.comentario, C.calificacion, C.email as emailContacto, C.activo as activoContacto
		FROM PROVEEDOR P
		LEFT JOIN CONTACTO C ON C.idProveedor = P.idProveedor and C.activo = 1
        WHERE P.idProveedor = p_idProveedor;
	END IF;
    
    IF p_tipoOperacion = 4 THEN 	
		select 
			P.idProveedor, 
			P.idContacto,
            P.nombreEmpresa,
			CONCAT(C.nombre, ' ', C.apePaterno) as nombre,
            M1.descripcion as categoria,
            M2.descripcion as estado,
			P.ruc,
			P.direccion,
			P.telefono1,
            P.telefono2,
            P.telefono3,
			P.email,
            P.activo
		from PROVEEDOR P
		INNER JOIN CONTACTO C ON C.idContacto = P.idContacto
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idRubro 
        INNER JOIN MULTITABLA M2 ON M2.valor = P.idEstado 
        WHERE M1.dep_id = 1 AND M2.dep_id = 2 AND P.activo = 1 and C.activo = 1 and P.idRubro in (2,3)
		ORDER BY P.nombreEmpresa;
	END IF;
    
    IF p_tipoOperacion = 5 THEN 	
		select 
			P.idProveedor, 			
            P.nombreEmpresa,
			-- CONCAT(C.nombre, ' ', C.apePaterno) as nombre,
            M1.descripcion as categoria,
            M2.descripcion as estado,
			P.ruc,
			P.direccion,
			P.telefono1,
            P.telefono2,
            P.telefono3,
			P.email,
            P.activo
		FROM PROVEEDOR P
		-- INNER JOIN CONTACTO C ON C.idProveedor = P.idProveedor
        INNER JOIN MULTITABLA M1 ON M1.valor = P.idRubro 
        LEFT JOIN MULTITABLA M2 ON M2.valor = P.idEstado AND M2.dep_id = 2
        WHERE M1.dep_id = 1 AND P.activo = 1 -- and C.activo = 1 
			and P.idRubro in (1,3)
		ORDER BY P.nombreEmpresa;
	END IF;
END
$